// To parse this JSON data, do
//
//     final dashboardResponseModel = dashboardResponseModelFromJson(jsonString);

import 'dart:convert';

DashboardResponseModel dashboardResponseModelFromJson(String str) => DashboardResponseModel.fromJson(json.decode(str));

String dashboardResponseModelToJson(DashboardResponseModel data) => json.encode(data.toJson());

class DashboardResponseModel {
    String? remark;
    String? status;
    Data? data;

    DashboardResponseModel({
        this.remark,
        this.status,
        this.data,
    });

    factory DashboardResponseModel.fromJson(Map<String, dynamic> json) => DashboardResponseModel(
        remark: json["remark"],
        status: json["status"],
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
    );

    Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "data": data?.toJson(),
    };
}

class Data {
    User? user;
    List<Transfer>? transfers;
    Widget? widget;

    Data({
        this.user,
        this.transfers,
        this.widget,
    });

    factory Data.fromJson(Map<String, dynamic> json) => Data(
        user: json["user"] == null ? null : User.fromJson(json["user"]),
        transfers: json["transfers"] == null ? [] : List<Transfer>.from(json["transfers"]!.map((x) => Transfer.fromJson(x))),
        widget: json["widget"] == null ? null : Widget.fromJson(json["widget"]),
    );

    Map<String, dynamic> toJson() => {
        "user": user?.toJson(),
        "transfers": transfers == null ? [] : List<dynamic>.from(transfers!.map((x) => x.toJson())),
        "widget": widget?.toJson(),
    };
}

class Transfer {
    int? id;
    String? mtcnNumber;
    String? trx;
    String? countryDeliveryMethodId;
    String? serviceId;
    String? userId;
    String? agentId;
    String? serviceFormData;
    String? baseCurrencyAmount;
    String? baseCurrencyCharge;
    String? sendingCountryId;
    String? sendingCurrency;
    String? sendingAmount;
    String? sendingCharge;
    String? recipientCountryId;
    String? recipientCurrency;
    String? recipientAmount;
    String? conversionRate;
    String? baseCurrencyRate;
    Recipient? sender;
    Recipient? recipient;
    String? sourceOfFundId;
    String? sendingPurposeId;
    String? verificationCode;
    String? verificationTime;
    String? payoutBy;
    String? paymentStatus;
    String? status;
    String? adminFeedback;
    String? receivedAt;
    String? createdAt;
    String? updatedAt;
    RecipientCountry? recipientCountry;
    Deposit? deposit;
    CountryDeliveryMethod? countryDeliveryMethod;

    Transfer({
        this.id,
        this.mtcnNumber,
        this.trx,
        this.countryDeliveryMethodId,
        this.serviceId,
        this.userId,
        this.agentId,
        this.serviceFormData,
        this.baseCurrencyAmount,
        this.baseCurrencyCharge,
        this.sendingCountryId,
        this.sendingCurrency,
        this.sendingAmount,
        this.sendingCharge,
        this.recipientCountryId,
        this.recipientCurrency,
        this.recipientAmount,
        this.conversionRate,
        this.baseCurrencyRate,
        this.sender,
        this.recipient,
        this.sourceOfFundId,
        this.sendingPurposeId,
        this.verificationCode,
        this.verificationTime,
        this.payoutBy,
        this.paymentStatus,
        this.status,
        this.adminFeedback,
        this.receivedAt,
        this.createdAt,
        this.updatedAt,
        this.recipientCountry,
        this.deposit,
        this.countryDeliveryMethod,
    });

    factory Transfer.fromJson(Map<String, dynamic> json) => Transfer(
        id: json["id"],
        mtcnNumber: json["mtcn_number"].toString(),
        trx: json["trx"].toString(),
        countryDeliveryMethodId: json["country_delivery_method_id"].toString(),
        serviceId: json["service_id"].toString(),
        userId: json["user_id"].toString(),
        agentId: json["agent_id"].toString(),
        serviceFormData: json["service_form_data"].toString(),
        baseCurrencyAmount: json["base_currency_amount"].toString(),
        baseCurrencyCharge: json["base_currency_charge"].toString(),
        sendingCountryId: json["sending_country_id"].toString(),
        sendingCurrency: json["sending_currency"].toString(),
        sendingAmount: json["sending_amount"].toString(),
        sendingCharge: json["sending_charge"].toString(),
        recipientCountryId: json["recipient_country_id"].toString(),
        recipientCurrency: json["recipient_currency"].toString(),
        recipientAmount: json["recipient_amount"].toString(),
        conversionRate: json["conversion_rate"].toString(),
        baseCurrencyRate: json["base_currency_rate"].toString(),
        sender: json["sender"] == null ? null : Recipient.fromJson(json["sender"]),
        recipient: json["recipient"] == null ? null : Recipient.fromJson(json["recipient"]),
        sourceOfFundId: json["source_of_fund_id"].toString(),
        sendingPurposeId: json["sending_purpose_id"].toString(),
        verificationCode: json["verification_code"].toString(),
        verificationTime: json["verification_time"] .toString(),
        payoutBy: json["payout_by"].toString(),
        paymentStatus: json["payment_status"].toString(),
        status: json["status"].toString(),
        adminFeedback: json["admin_feedback"].toString(),
        receivedAt: json["received_at"] .toString(),
        createdAt: json["created_at"] .toString(),
        updatedAt: json["updated_at"].toString(),
        recipientCountry: json["recipient_country"] == null ? null : RecipientCountry.fromJson(json["recipient_country"]),
        deposit: json["deposit"] == null ? null : Deposit.fromJson(json["deposit"]),
         countryDeliveryMethod: json["country_delivery_method"] == null ? null : CountryDeliveryMethod.fromJson(json["country_delivery_method"]),
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "mtcn_number": mtcnNumber,
        "trx": trx,
        "country_delivery_method_id": countryDeliveryMethodId,
        "service_id": serviceId,
        "user_id": userId,
        "agent_id": agentId,
        "service_form_data": serviceFormData,
        "base_currency_amount": baseCurrencyAmount,
        "base_currency_charge": baseCurrencyCharge,
        "sending_country_id": sendingCountryId,
        "sending_currency": sendingCurrency,
        "sending_amount": sendingAmount,
        "sending_charge": sendingCharge,
        "recipient_country_id": recipientCountryId,
        "recipient_currency": recipientCurrency,
        "recipient_amount": recipientAmount,
        "conversion_rate": conversionRate,
        "base_currency_rate": baseCurrencyRate,
        "sender": sender?.toJson(),
        "recipient": recipient?.toJson(),
        "source_of_fund_id": sourceOfFundId,
        "sending_purpose_id": sendingPurposeId,
        "verification_code": verificationCode,
        "verification_time": verificationTime,
        "payout_by": payoutBy,
        "payment_status": paymentStatus,
        "status": status,
        "admin_feedback": adminFeedback,
        "received_at": receivedAt,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "recipient_country": recipientCountry?.toJson(),
        "deposit": deposit?.toJson(),
         "country_delivery_method": countryDeliveryMethod?.toJson(),
    };
}
class CountryDeliveryMethod {
    int? id;
    int? countryId;
    int? deliveryMethodId;
    DeliveryMethod? deliveryMethod;

    CountryDeliveryMethod({
        this.id,
        this.countryId,
        this.deliveryMethodId,
        this.deliveryMethod,
    });

    factory CountryDeliveryMethod.fromJson(Map<String, dynamic> json) => CountryDeliveryMethod(
        id: json["id"],
        countryId: json["country_id"],
        deliveryMethodId: json["delivery_method_id"],
        deliveryMethod: json["delivery_method"] == null ? null : DeliveryMethod.fromJson(json["delivery_method"]),
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "country_id": countryId,
        "delivery_method_id": deliveryMethodId,
        "delivery_method": deliveryMethod?.toJson(),
    };
}

class DeliveryMethod {
    int? id;
    String? name;
    int? status;
    DateTime? createdAt;
    DateTime? updatedAt;

    DeliveryMethod({
        this.id,
        this.name,
        this.status,
        this.createdAt,
        this.updatedAt,
    });

    factory DeliveryMethod.fromJson(Map<String, dynamic> json) => DeliveryMethod(
        id: json["id"],
        name: json["name"],
        status: json["status"],
        createdAt: json["created_at"] == null ? null : DateTime.parse(json["created_at"]),
        updatedAt: json["updated_at"] == null ? null : DateTime.parse(json["updated_at"]),
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "status": status,
        "created_at": createdAt?.toIso8601String(),
        "updated_at": updatedAt?.toIso8601String(),
    };
}

class Deposit {
    int? id;
    String? userId;
    String? agentId;
    String? sendMoneyId;
    String? methodCode;
    String? amount;
    String? methodCurrency;
    String? charge;
    String? rate;
    String? finalAmount;
    String? btcAmount;
    String? btcWallet;
    String? trx;
    String? paymentTry;
    String? status;
    String? fromApi;
    String? adminFeedback;
    String? successUrl;
    String? failedUrl;
    String? lastCron;
    String? createdAt;
    String? updatedAt;
    Gateway? gateway;

    Deposit({
        this.id,
        this.userId,
        this.agentId,
        this.sendMoneyId,
        this.methodCode,
        this.amount,
        this.methodCurrency,
        this.charge,
        this.rate,
        this.finalAmount,
        this.btcAmount,
        this.btcWallet,
        this.trx,
        this.paymentTry,
        this.status,
        this.fromApi,
        this.adminFeedback,
        this.successUrl,
        this.failedUrl,
        this.lastCron,
        this.createdAt,
        this.updatedAt,
        this.gateway,
    });

    factory Deposit.fromJson(Map<String, dynamic> json) => Deposit(
        id: json["id"],
        userId: json["user_id"].toString(),
        agentId: json["agent_id"].toString(),
        sendMoneyId: json["send_money_id"].toString(),
        methodCode: json["method_code"].toString(),
        amount: json["amount"].toString(),
        methodCurrency: json["method_currency"].toString(),
        charge: json["charge"].toString(),
        rate: json["rate"].toString(),
        finalAmount: json["final_amount"].toString(),
        btcAmount: json["btc_amount"].toString(),
        btcWallet: json["btc_wallet"].toString(),
        trx: json["trx"].toString(),
        paymentTry: json["payment_try"].toString(),
        status: json["status"].toString(),
        fromApi: json["from_api"].toString(),
        adminFeedback: json["admin_feedback"].toString(),
        successUrl: json["success_url"].toString(),
        failedUrl: json["failed_url"].toString(),
        lastCron: json["last_cron"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"] .toString(),
        gateway: json["gateway"] == null ? null : Gateway.fromJson(json["gateway"]),
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "agent_id": agentId,
        "send_money_id": sendMoneyId,
        "method_code": methodCode,
        "amount": amount,
        "method_currency": methodCurrency,
        "charge": charge,
        "rate": rate,
        "final_amount": finalAmount,
        "btc_amount": btcAmount,
        "btc_wallet": btcWallet,
        "trx": trx,
        "payment_try": paymentTry,
        "status": status,
        "from_api": fromApi,
        "admin_feedback": adminFeedback,
        "success_url": successUrl,
        "failed_url": failedUrl,
        "last_cron": lastCron,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "gateway": gateway?.toJson(),
    };
}

class Gateway {
    int? id;
    String? formId;
    String? code;
    String? name;
    String? alias;
    String? image;
    String? status;
    String? supportedCurrencies;
    String? crypto;
    String? description;
    String? createdAt;
    String? updatedAt;

    Gateway({
        this.id,
        this.formId,
        this.code,
        this.name,
        this.alias,
        this.image,
        this.status,
        this.supportedCurrencies,
        this.crypto,
        this.description,
        this.createdAt,
        this.updatedAt,
    });

    factory Gateway.fromJson(Map<String, dynamic> json) => Gateway(
        id: json["id"],
        formId: json["form_id"].toString(),
        code: json["code"].toString(),
        name: json["name"].toString(),
        alias: json["alias"].toString(),
        image: json["image"].toString(),
        status: json["status"].toString(),
        supportedCurrencies: json["supported_currencies"].toString(),
        crypto: json["crypto"].toString(),
        description: json["description"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "form_id": formId,
        "code": code,
        "name": name,
        "alias": alias,
        "image": image,
        "status": status,
        "supported_currencies": supportedCurrencies,
        "crypto": crypto,
        "description": description,
        "created_at": createdAt,
        "updated_at": updatedAt,
    };
}

class SupportedCurrenciesClass {
    String? usd;
    String? aud;
    String? brl;
    String? cad;
    String? chf;
    String? dkk;
    String? eur;
    String? gbp;
    String? hkd;
    String? inr;
    String? jpy;
    String? mxn;
    String? myr;
    String? nok;
    String? nzd;
    String? pln;
    String? sek;
    String? sgd;
    String? bif;
    String? cdf;
    String? cve;
    String? ghs;
    String? gmd;
    String? gnf;
    String? kes;
    String? lrd;
    String? mwk;
    String? mzn;
    String? ngn;
    String? rwf;
    String? sll;
    String? std;
    String? tzs;
    String? ugx;
    String? xaf;
    String? xof;
    String? zmk;
    String? zmw;
    String? zwd;

    SupportedCurrenciesClass({
        this.usd,
        this.aud,
        this.brl,
        this.cad,
        this.chf,
        this.dkk,
        this.eur,
        this.gbp,
        this.hkd,
        this.inr,
        this.jpy,
        this.mxn,
        this.myr,
        this.nok,
        this.nzd,
        this.pln,
        this.sek,
        this.sgd,
        this.bif,
        this.cdf,
        this.cve,
        this.ghs,
        this.gmd,
        this.gnf,
        this.kes,
        this.lrd,
        this.mwk,
        this.mzn,
        this.ngn,
        this.rwf,
        this.sll,
        this.std,
        this.tzs,
        this.ugx,
        this.xaf,
        this.xof,
        this.zmk,
        this.zmw,
        this.zwd,
    });

    factory SupportedCurrenciesClass.fromJson(Map<String, dynamic> json) => SupportedCurrenciesClass(
        usd: json["USD"].toString(),
        aud: json["AUD"].toString(),
        brl: json["BRL"].toString(),
        cad: json["CAD"].toString(),
        chf: json["CHF"].toString(),
        dkk: json["DKK"].toString(),
        eur: json["EUR"].toString(),
        gbp: json["GBP"].toString(),
        hkd: json["HKD"].toString(),
        inr: json["INR"].toString(),
        jpy: json["JPY"].toString(),
        mxn: json["MXN"].toString(),
        myr: json["MYR"].toString(),
        nok: json["NOK"].toString(),
        nzd: json["NZD"].toString(),
        pln: json["PLN"].toString(),
        sek: json["SEK"].toString(),
        sgd: json["SGD"].toString(),
        bif: json["BIF"].toString(),
        cdf: json["CDF"].toString(),
        cve: json["CVE"].toString(),
        ghs: json["GHS"].toString(),
        gmd: json["GMD"].toString(),
        gnf: json["GNF"].toString(),
        kes: json["KES"].toString(),
        lrd: json["LRD"].toString(),
        mwk: json["MWK"].toString(),
        mzn: json["MZN"].toString(),
        ngn: json["NGN"].toString(),
        rwf: json["RWF"].toString(),
        sll: json["SLL"].toString(),
        std: json["STD"].toString(),
        tzs: json["TZS"].toString(),
        ugx: json["UGX"].toString(),
        xaf: json["XAF"].toString(),
        xof: json["XOF"].toString(),
        zmk: json["ZMK"].toString(),
        zmw: json["ZMW"].toString(),
        zwd: json["ZWD"].toString(),
    );

    Map<String, dynamic> toJson() => {
        "USD": usd,
        "AUD": aud,
        "BRL": brl,
        "CAD": cad,
        "CHF": chf,
        "DKK": dkk,
        "EUR": eur,
        "GBP": gbp,
        "HKD": hkd,
        "INR": inr,
        "JPY": jpy,
        "MXN": mxn,
        "MYR": myr,
        "NOK": nok,
        "NZD": nzd,
        "PLN": pln,
        "SEK": sek,
        "SGD": sgd,
        "BIF": bif,
        "CDF": cdf,
        "CVE": cve,
        "GHS": ghs,
        "GMD": gmd,
        "GNF": gnf,
        "KES": kes,
        "LRD": lrd,
        "MWK": mwk,
        "MZN": mzn,
        "NGN": ngn,
        "RWF": rwf,
        "SLL": sll,
        "STD": std,
        "TZS": tzs,
        "UGX": ugx,
        "XAF": xaf,
        "XOF": xof,
        "ZMK": zmk,
        "ZMW": zmw,
        "ZWD": zwd,
    };
}

class Recipient {
    String? name;
    String? mobile;
    String? email;
    String? address;

    Recipient({
        this.name,
        this.mobile,
        this.email,
        this.address,
    });

    factory Recipient.fromJson(Map<String, dynamic> json) => Recipient(
        name: json["name"].toString(),
        mobile: json["mobile"].toString(),
        email: json["email"].toString(),
        address: json["address"].toString(),
    );

    Map<String, dynamic> toJson() => {
        "name": name,
        "mobile": mobile,
        "email": email,
        "address": address,
    };
}

class RecipientCountry {
    int? id;
    String? name;
    String? countryCode;
    String? dialCode;
    String? currency;
    String? rate;
    String? image;
    String? isSending;
    String? isReceiving;
    String? hasAgent;
    String? status;
    String? createdAt;
    String? updatedAt;

    RecipientCountry({
        this.id,
        this.name,
        this.countryCode,
        this.dialCode,
        this.currency,
        this.rate,
        this.image,
        this.isSending,
        this.isReceiving,
        this.hasAgent,
        this.status,
        this.createdAt,
        this.updatedAt,
    });

    factory RecipientCountry.fromJson(Map<String, dynamic> json) => RecipientCountry(
        id: json["id"],
        name: json["name"].toString(),
        countryCode: json["country_code"].toString(),
        dialCode: json["dial_code"].toString(),
        currency: json["currency"].toString(),
        rate: json["rate"].toString(),
        image: json["image"].toString(),
        isSending: json["is_sending"].toString(),
        isReceiving: json["is_receiving"].toString(),
        hasAgent: json["has_agent"].toString(),
        status: json["status"].toString(),
        createdAt: json["created_at"] .toString(),
        updatedAt: json["updated_at"].toString(),
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "country_code": countryCode,
        "dial_code": dialCode,
        "currency": currency,
        "rate": rate,
        "image": image,
        "is_sending": isSending,
        "is_receiving": isReceiving,
        "has_agent": hasAgent,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
    };
}

class User {
    int? id;
    String? firstname;
    String? lastname;
    String? username;
    String? companyName;
    String? ownerName;
    String? email;
    String? dialCode;
    String? countryCode;
    String? countryName;
    String? state;
    String? city;
    String? zip;
    String? mobile;
    String? refBy;
    String? totalBonusGiven;
    String? image;
    String? address;
    String? status;
    String? type;
    String? businessProfileData;
    String? kycRejectionReason;
    String? kv;
    String? ev;
    String? sv;
    String? profileComplete;
    String? verCodeSendAt;
    String? ts;
    String? tv;
    String? tsc;
    String? banReason;
    String? perSendMoneyLimit;
    String? dailySendMoneyLimit;
    String? monthlySendMoneyLimit;
    String? createdAt;
    String? updatedAt;

    User({
        this.id,
        this.firstname,
        this.lastname,
        this.username,
        this.companyName,
        this.ownerName,
        this.email,
        this.dialCode,
        this.countryCode,
        this.countryName,
        this.state,
        this.city,
        this.zip,
        this.mobile,
        this.refBy,
        this.totalBonusGiven,
        this.image,
        this.address,
        this.status,
        this.type,
        this.businessProfileData,
        this.kycRejectionReason,
        this.kv,
        this.ev,
        this.sv,
        this.profileComplete,
        this.verCodeSendAt,
        this.ts,
        this.tv,
        this.tsc,
        this.banReason,
        this.perSendMoneyLimit,
        this.dailySendMoneyLimit,
        this.monthlySendMoneyLimit,
        this.createdAt,
        this.updatedAt,
    });

    factory User.fromJson(Map<String, dynamic> json) => User(
        id: json["id"],
        firstname: json["firstname"].toString(),
        lastname: json["lastname"].toString(),
        username: json["username"].toString(),
        companyName: json["company_name"].toString(),
        ownerName: json["owner_name"].toString(),
        email: json["email"].toString(),
        dialCode: json["dial_code"].toString(),
        countryCode: json["country_code"].toString(),
        countryName: json["country_name"].toString(),
        state: json["state"].toString(),
        city: json["city"].toString(),
        zip: json["zip"].toString(),
        mobile: json["mobile"].toString(),
        refBy: json["ref_by"].toString(),
        totalBonusGiven: json["total_bonus_given"].toString(),
        image: json["image"].toString(),
        address: json["address"].toString(),
        status: json["status"].toString(),
        type: json["type"].toString(),
        businessProfileData: json["business_profile_data"].toString(),
        kycRejectionReason: json["kyc_rejection_reason"].toString(),
        kv: json["kv"].toString(),
        ev: json["ev"].toString(),
        sv: json["sv"].toString(),
        profileComplete: json["profile_complete"].toString(),
        verCodeSendAt: json["ver_code_send_at"].toString(),
        ts: json["ts"].toString(),
        tv: json["tv"].toString(),
        tsc: json["tsc"].toString(),
        banReason: json["ban_reason"].toString(),
        perSendMoneyLimit: json["per_send_money_limit"].toString(),
        dailySendMoneyLimit: json["daily_send_money_limit"].toString(),
        monthlySendMoneyLimit: json["monthly_send_money_limit"].toString(),
        createdAt: json["created_at"].toString(),
        updatedAt: json["updated_at"].toString(),
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "firstname": firstname,
        "lastname": lastname,
        "username": username,
        "company_name": companyName,
        "owner_name": ownerName,
        "email": email,
        "dial_code": dialCode,
        "country_code": countryCode,
        "country_name": countryName,
        "state": state,
        "city": city,
        "zip": zip,
        "mobile": mobile,
        "ref_by": refBy,
        "total_bonus_given": totalBonusGiven,
        "image": image,
        "address": address,
        "status": status,
        "type": type,
        "business_profile_data": businessProfileData,
        "kyc_rejection_reason": kycRejectionReason,
        "kv": kv,
        "ev": ev,
        "sv": sv,
        "profile_complete": profileComplete,
        "ver_code_send_at": verCodeSendAt,
        "ts": ts,
        "tv": tv,
        "tsc": tsc,
        "ban_reason": banReason,
        "per_send_money_limit": perSendMoneyLimit,
        "daily_send_money_limit": dailySendMoneyLimit,
        "monthly_send_money_limit": monthlySendMoneyLimit,
        "created_at": createdAt,
        "updated_at": updatedAt,
    };
}

class Widget {
    String? balance;
    String? sendMoneyAmount;
    String? sendMoneyPending;
    String? sendMoneyInitiated;
    String? paymentPending;
    String? paymentRejected;

    Widget({
        this.balance,
        this.sendMoneyAmount,
        this.sendMoneyPending,
        this.sendMoneyInitiated,
        this.paymentPending,
        this.paymentRejected,
    });

    factory Widget.fromJson(Map<String, dynamic> json) => Widget(
        balance: json["balance"].toString(),
        sendMoneyAmount: json["send_money_amount"].toString(),
        sendMoneyPending: json["send_money_pending"].toString(),
        sendMoneyInitiated: json["send_money_initiated"].toString(),
        paymentPending: json["payment_pending"].toString(),
        paymentRejected: json["payment_rejected"].toString(),
    );

    Map<String, dynamic> toJson() => {
        "balance": balance,
        "send_money_amount": sendMoneyAmount,
        "send_money_pending": sendMoneyPending,
        "send_money_initiated": sendMoneyInitiated,
        "payment_pending": paymentPending,
        "payment_rejected": paymentRejected,
    };
}
